@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-0">Servis Durum Geçmişi</h4>
                        <small class="text-muted">{{ $serviceRecord->tracking_number }}</small>
                    </div>
                    <a href="{{ route('service-records.show', $serviceRecord) }}" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Geri Dön
                    </a>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>Servis Bilgileri</h5>
                            <p><strong>Müşteri:</strong> {{ $serviceRecord->customer->name }}</p>
                            <p><strong>Cihaz:</strong> {{ $serviceRecord->device->brand }} {{ $serviceRecord->device->model }}</p>
                            <p><strong>Mevcut Durum:</strong> 
                                <span class="badge bg-{{ $serviceRecord->status === 'completed' ? 'success' : ($serviceRecord->status === 'cancelled' ? 'danger' : 'primary') }}">
                                    {{ $serviceRecord->status }}
                                </span>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h5>Özet</h5>
                            <p><strong>Toplam Değişiklik:</strong> {{ $statusChanges->count() }} kez</p>
                            <p><strong>İlk Değişiklik:</strong> {{ $statusChanges->last()->changed_at->format('d.m.Y H:i') }}</p>
                            <p><strong>Son Değişiklik:</strong> {{ $statusChanges->first()->changed_at->format('d.m.Y H:i') }}</p>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Tarih</th>
                                    <th>Eski Durum</th>
                                    <th>Yeni Durum</th>
                                    <th>Değiştiren</th>
                                    <th>Açıklama</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($statusChanges as $change)
                                    <tr>
                                        <td>{{ $change->changed_at->format('d.m.Y H:i') }}</td>
                                        <td>
                                            @if($change->old_status)
                                                <span class="badge bg-secondary">{{ $change->old_status }}</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $change->new_status === 'completed' ? 'success' : ($change->new_status === 'cancelled' ? 'danger' : 'primary') }}">
                                                {{ $change->new_status }}
                                            </span>
                                        </td>
                                        <td>{{ $change->changedBy->name }}</td>
                                        <td>{{ $change->description ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @if($statusChanges->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            {{ $statusChanges->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 