@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Teknik Servis Personeli Raporu</h3>
                    <div class="card-tools">
                        <form action="{{ route('service-records.reports.technician') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <label for="start_date" class="mr-2">Başlangıç Tarihi:</label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                            </div>
                            <div class="form-group mr-2">
                                <label for="end_date" class="mr-2">Bitiş Tarihi:</label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                            </div>
                            <button type="submit" class="btn btn-primary">Filtrele</button>
                        </form>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Teknik Servis Personeli</th>
                                    <th>Toplam Atanan Kayıt</th>
                                    <th>Yüzde</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total = $technicianReport->sum('total');
                                @endphp
                                @foreach($technicianReport as $report)
                                    <tr>
                                        <td>{{ $report->technician->name }}</td>
                                        <td>{{ $report->total }}</td>
                                        <td>{{ number_format(($report->total / $total) * 100, 2) }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Toplam</th>
                                    <th>{{ $total }}</th>
                                    <th>100%</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="mt-4">
                        <canvas id="technicianChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('technicianChart').getContext('2d');
        const data = {
            labels: {!! json_encode($technicianReport->pluck('technician.name')) !!},
            datasets: [{
                label: 'Atanan Kayıt Sayısı',
                data: {!! json_encode($technicianReport->pluck('total')) !!},
                backgroundColor: '#36a2eb',
                borderColor: '#36a2eb',
                borderWidth: 1
            }]
        };
        new Chart(ctx, {
            type: 'bar',
            data: data,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Teknik Servis Personeli Atama Dağılımı'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    });
</script>
@endpush 