@props([
    'serviceRecord' => null,
    'statuses' => [],
    'technicians' => []
])

<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ isset($serviceRecord) ? __('Servis Kaydını Düzenle') : __('Yeni Servis Kaydı') }}
            </h2>
            <a href="{{ route('service-records.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                {{ __('Geri Dön') }}
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ isset($serviceRecord) ? route('service-records.update', $serviceRecord) : route('service-records.store') }}" method="POST">
                        @csrf
                        @if(isset($serviceRecord))
                            @method('PUT')
                        @endif

                        <!-- Müşteri Bilgileri -->
                        <div class="mb-8">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Müşteri Bilgileri') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <x-label for="customer_name" :value="__('Ad Soyad')" />
                                    <x-input id="customer_name" class="block mt-1 w-full" type="text" name="customer_name" :value="old('customer_name', $serviceRecord->customer_name ?? '')" required />
                                    <x-input-error for="customer_name" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="customer_phone" :value="__('Telefon')" />
                                    <x-input id="customer_phone" class="block mt-1 w-full" type="text" name="customer_phone" :value="old('customer_phone', $serviceRecord->customer_phone ?? '')" required />
                                    <x-input-error for="customer_phone" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="customer_email" :value="__('E-posta')" />
                                    <x-input id="customer_email" class="block mt-1 w-full" type="email" name="customer_email" :value="old('customer_email', $serviceRecord->customer_email ?? '')" />
                                    <x-input-error for="customer_email" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="customer_address" :value="__('Adres')" />
                                    <x-textarea id="customer_address" name="customer_address" class="block mt-1 w-full" rows="3">{{ old('customer_address', $serviceRecord->customer_address ?? '') }}</x-textarea>
                                    <x-input-error for="customer_address" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <!-- Cihaz Bilgileri -->
                        <div class="mb-8">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Cihaz Bilgileri') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <x-label for="device_brand" :value="__('Marka')" />
                                    <x-input id="device_brand" class="block mt-1 w-full" type="text" name="device_brand" :value="old('device_brand', $serviceRecord->device_brand ?? '')" required />
                                    <x-input-error for="device_brand" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="device_model" :value="__('Model')" />
                                    <x-input id="device_model" class="block mt-1 w-full" type="text" name="device_model" :value="old('device_model', $serviceRecord->device_model ?? '')" required />
                                    <x-input-error for="device_model" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="device_serial_number" :value="__('Seri No')" />
                                    <x-input id="device_serial_number" class="block mt-1 w-full" type="text" name="device_serial_number" :value="old('device_serial_number', $serviceRecord->device_serial_number ?? '')" required />
                                    <x-input-error for="device_serial_number" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="fault_description" :value="__('Arıza Açıklaması')" />
                                    <x-textarea id="fault_description" name="fault_description" class="block mt-1 w-full" rows="3" required>{{ old('fault_description', $serviceRecord->fault_description ?? '') }}</x-textarea>
                                    <x-input-error for="fault_description" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <!-- Servis Bilgileri -->
                        <div class="mb-8">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Servis Bilgileri') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                @if(isset($serviceRecord))
                                    <div>
                                        <x-label for="tracking_number" :value="__('Takip No')" />
                                        <x-input id="tracking_number" class="block mt-1 w-full bg-gray-100" type="text" :value="$serviceRecord->tracking_number" disabled />
                                    </div>
                                @endif

                                <div>
                                    <x-label for="status" :value="__('Durum')" />
                                    <x-select id="status" name="status" class="block mt-1 w-full" required>
                                        @foreach($statuses as $key => $value)
                                            <option value="{{ $key }}" {{ old('status', $serviceRecord->status ?? '') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                        @endforeach
                                    </x-select>
                                    <x-input-error for="status" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="technician_id" :value="__('Teknisyen')" />
                                    <x-select id="technician_id" name="technician_id" class="block mt-1 w-full">
                                        <option value="">{{ __('Seçiniz') }}</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id', $serviceRecord->technician_id ?? '') == $technician->id ? 'selected' : '' }}>{{ $technician->name }}</option>
                                        @endforeach
                                    </x-select>
                                    <x-input-error for="technician_id" class="mt-2" />
                                </div>

                                <div>
                                    <x-label for="notes" :value="__('Notlar')" />
                                    <x-textarea id="notes" name="notes" class="block mt-1 w-full" rows="3">{{ old('notes', $serviceRecord->notes ?? '') }}</x-textarea>
                                    <x-input-error for="notes" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-end">
                            <x-button class="ml-4">
                                {{ isset($serviceRecord) ? __('Güncelle') : __('Kaydet') }}
                            </x-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 