<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Servis Kaydı Detayı') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Cihaz Bilgileri -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Cihaz Bilgileri</h3>
                            <dl class="grid grid-cols-1 gap-4">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Marka</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->brand }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Model</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->model }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Seri No</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->serial_number }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Arıza Açıklaması</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->fault_description }}</dd>
                                </div>
                            </dl>
                        </div>

                        <!-- Servis Durumu -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Servis Durumu</h3>
                            <dl class="grid grid-cols-1 gap-4">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">İşlem Numarası</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->tracking_number }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Durum</dt>
                                    <dd class="mt-1">
                                        @php
                                            $statusColors = [
                                                'pending' => 'bg-yellow-100 text-yellow-800',
                                                'in_progress' => 'bg-blue-100 text-blue-800',
                                                'waiting_for_parts' => 'bg-red-100 text-red-800',
                                                'completed' => 'bg-green-100 text-green-800',
                                                'cancelled' => 'bg-gray-100 text-gray-800'
                                            ];
                                            $statusLabels = [
                                                'pending' => 'Beklemede',
                                                'in_progress' => 'İşlemde',
                                                'waiting_for_parts' => 'Parça Bekliyor',
                                                'completed' => 'Tamamlandı',
                                                'cancelled' => 'İptal Edildi'
                                            ];
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColors[$serviceRecord->status] }}">
                                            {{ $statusLabels[$serviceRecord->status] }}
                                        </span>
                                    </dd>
                                </div>
                                @if($serviceRecord->technician)
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">Tekniker</dt>
                                        <dd class="mt-1 text-sm text-gray-900">
                                            {{ $serviceRecord->technician->name }}
                                            <br>
                                            <span class="text-gray-500">{{ $serviceRecord->technician->phone }}</span>
                                        </dd>
                                    </div>
                                @endif
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Oluşturulma Tarihi</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->created_at->format('d.m.Y H:i') }}</dd>
                                </div>
                                @if($serviceRecord->status === 'completed')
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">Tamamlanma Tarihi</dt>
                                        <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->updated_at->format('d.m.Y H:i') }}</dd>
                                    </div>
                                @endif
                            </dl>
                        </div>
                    </div>

                    <!-- Notlar -->
                    @if($serviceRecord->notes->isNotEmpty())
                        <div class="mt-8">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">İşlem Notları</h3>
                            <div class="space-y-4">
                                @foreach($serviceRecord->notes as $note)
                                    <div class="bg-gray-50 p-4 rounded-lg">
                                        <div class="flex justify-between items-start">
                                            <div>
                                                <p class="text-sm text-gray-900">{{ $note->content }}</p>
                                                <p class="mt-1 text-xs text-gray-500">
                                                    {{ $note->created_at->format('d.m.Y H:i') }}
                                                </p>
                                            </div>
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($note->type === 'status_change') bg-blue-100 text-blue-800
                                                @elseif($note->type === 'technician_note') bg-green-100 text-green-800
                                                @else bg-gray-100 text-gray-800 @endif">
                                                @if($note->type === 'status_change') Durum Değişikliği
                                                @elseif($note->type === 'technician_note') Tekniker Notu
                                                @else Genel Not @endif
                                            </span>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <div class="mt-6">
                        <a href="{{ route('service-record.query.index') }}" class="text-blue-600 hover:text-blue-900">
                            ← Yeni Sorgulama Yap
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 