<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Servis Durumu Değişikliği</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .content {
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #666;
        }
        .status {
            font-weight: bold;
            color: #007bff;
        }
        .tracking-number {
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            font-family: monospace;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Servis Durumu Güncellendi</h2>
    </div>

    <div class="content">
        <p>Sayın {{ $serviceRecord->customer_name }},</p>

        <p>Servis kaydınızın durumu güncellenmiştir.</p>

        <div class="tracking-number">
            Takip Numarası: {{ $serviceRecord->tracking_number }}
        </div>

        <p>
            <strong>Eski Durum:</strong> {{ $oldStatus }}<br>
            <strong>Yeni Durum:</strong> <span class="status">{{ $serviceRecord->status }}</span>
        </p>

        @if($serviceRecord->status_description)
            <p>
                <strong>Açıklama:</strong><br>
                {{ $serviceRecord->status_description }}
            </p>
        @endif

        <p>
            Servis kaydınızın detaylarını görüntülemek için aşağıdaki bağlantıyı kullanabilirsiniz:<br>
            <a href="{{ route('service-records.show', $serviceRecord->id) }}">
                {{ route('service-records.show', $serviceRecord->id) }}
            </a>
        </p>

        <p>
            Sorularınız için bizimle iletişime geçebilirsiniz.<br>
            Telefon: {{ config('app.phone') }}<br>
            E-posta: {{ config('app.email') }}
        </p>
    </div>

    <div class="footer">
        <p>Bu e-posta otomatik olarak gönderilmiştir. Lütfen yanıtlamayınız.</p>
        <p>&copy; {{ date('Y') }} {{ config('app.name') }}. Tüm hakları saklıdır.</p>
    </div>
</body>
</html> 