@props(['notification'])

<div class="flex items-start">
    <div class="flex-shrink-0">
        @if($notification->type === 'App\Notifications\ServiceStatusUpdated')
            <svg class="h-6 w-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
            </svg>
        @elseif($notification->type === 'App\Notifications\TechnicianAssigned')
            <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
            </svg>
        @endif
    </div>
    <div class="ml-3 w-0 flex-1">
        <p class="text-sm font-medium text-gray-900">
            @if($notification->type === 'App\Notifications\ServiceStatusUpdated')
                Service Status Updated
            @elseif($notification->type === 'App\Notifications\TechnicianAssigned')
                Technician Assigned
            @endif
        </p>
        <p class="text-sm text-gray-500">
            Tracking No: {{ $notification->data['tracking_number'] }}
        </p>
        <div class="mt-1 flex">
            <a href="{{ route('service-records.show', $notification->data['service_record_id']) }}" class="text-sm text-indigo-600 hover:text-indigo-900">
                View
            </a>
            @if(!$notification->read_at)
                <form action="{{ route('notifications.markAsRead', $notification->id) }}" method="POST" class="ml-3">
                    @csrf
                    <button type="submit" class="text-sm text-gray-500 hover:text-gray-900">
                        Mark as read
                    </button>
                </form>
            @endif
        </div>
    </div>
    <div class="ml-4 flex-shrink-0 flex">
        <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST">
            @csrf
            @method('DELETE')
            <button type="submit" class="text-gray-400 hover:text-gray-500">
                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </form>
    </div>
</div> 