<?php

namespace App\Services;

use App\Models\SmsSetting;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class NetGSMService
{
    protected $settings;

    public function __construct()
    {
        $this->settings = SmsSetting::where('is_active', true)->first();
    }

    public function sendSMS($phone, $message)
    {
        if (!$this->settings) {
            Log::error('SMS gönderimi için ayarlar bulunamadı veya aktif değil');
            return false;
        }

        try {
            $response = Http::get('https://api.netgsm.com.tr/sms/send/xml', [
                'usercode' => $this->settings->username,
                'password' => $this->settings->password,
                'gsmno' => $phone,
                'message' => $message,
                'msgheader' => $this->settings->header
            ]);

            $result = simplexml_load_string($response->body());
            
            if ($result->main->code == '00') {
                Log::info('SMS başarıyla gönderildi', [
                    'phone' => $phone,
                    'message' => $message
                ]);
                return true;
            } else {
                Log::error('SMS gönderimi başarısız', [
                    'phone' => $phone,
                    'message' => $message,
                    'error' => $result->main->code
                ]);
                return false;
            }
        } catch (\Exception $e) {
            Log::error('SMS gönderimi sırasında hata oluştu', [
                'phone' => $phone,
                'message' => $message,
                'error' => $e->getMessage()
            ]);
            return false;
        }
    }

    public function getTemplate($key, $replacements = [])
    {
        if (!$this->settings) {
            return null;
        }

        $template = $this->settings->templates[$key] ?? null;
        
        if (!$template) {
            return null;
        }

        foreach ($replacements as $key => $value) {
            $template = str_replace('{' . $key . '}', $value, $template);
        }

        return $template;
    }
} 