<?php

namespace App\Providers;

use App\Models\ServiceRecord;
use App\Models\User;
use App\Policies\ServiceRecordPolicy;
use App\Policies\UserPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        ServiceRecord::class => ServiceRecordPolicy::class,
        User::class => UserPolicy::class,
    ];

    public function boot()
    {
        $this->registerPolicies();

        // Genel yetki kontrolleri
        Gate::define('is-admin', function ($user) {
            return $user->isAdmin();
        });

        Gate::define('is-service-manager', function ($user) {
            return $user->isServiceManager();
        });

        Gate::define('is-service-staff', function ($user) {
            return $user->isServiceStaff();
        });
    }
} 