<?php

namespace App\Policies;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ServiceRecordPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin', 'service_manager', 'service_staff']);
    }

    public function view(User $user, ServiceRecord $serviceRecord): bool
    {
        // Admin, servis yöneticisi ve servis personeli tüm kayıtları görebilir
        if ($user->hasAnyRole(['admin', 'service_manager', 'service_staff'])) {
            return true;
        }

        // Teknisyen sadece kendisine atanan kayıtları görebilir
        if ($user->hasRole('technician')) {
            return $serviceRecord->technician_id === $user->id;
        }

        // Müşteri sadece kendi kayıtlarını görebilir
        if ($user->hasRole('customer')) {
            return $serviceRecord->customer_id === $user->id;
        }

        return false;
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin', 'service_manager', 'service_staff']);
    }

    public function update(User $user, ServiceRecord $serviceRecord): bool
    {
        // Admin ve servis yöneticisi tüm servis kayıtlarını güncelleyebilir
        if ($user->hasAnyRole(['admin', 'service_manager'])) {
            return true;
        }

        // Servis personeli tüm servis kayıtlarını güncelleyebilir
        if ($user->hasRole('service_staff')) {
            return true;
        }

        return false;
    }

    public function delete(User $user, ServiceRecord $serviceRecord): bool
    {
        // Sadece admin servis kayıtlarını silebilir
        return $user->hasRole('admin');
    }

    public function assignTechnician(User $user, ServiceRecord $serviceRecord): bool
    {
        return $user->hasAnyRole(['admin', 'service_manager', 'service_staff']);
    }

    public function changeStatus(User $user, ServiceRecord $serviceRecord): bool
    {
        return $user->hasAnyRole(['admin', 'service_manager', 'service_staff']);
    }

    public function viewStatusHistory(User $user, ServiceRecord $serviceRecord): bool
    {
        return true;
    }

    public function viewStatistics(User $user): bool
    {
        return $user->hasAnyRole(['admin', 'service_manager', 'service_staff'], 'api');
    }
} 