<?php

namespace App\Notifications;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Mail\Mailable;
use Illuminate\Mail\Mailable as BaseMailable;
use Illuminate\Queue\SerializesModels;

class TechnicianAssigned extends BaseMailable implements Mailable
{
    use Queueable, SerializesModels;

    public $serviceRecord;
    public $technician;
    public $assignedBy;

    public function __construct(ServiceRecord $serviceRecord, User $technician, User $assignedBy)
    {
        $this->serviceRecord = $serviceRecord;
        $this->technician = $technician;
        $this->assignedBy = $assignedBy;
    }

    public function build()
    {
        return $this->markdown('emails.technician-assigned')
            ->subject('Teknik Servis Personeli Atandı - ' . $this->serviceRecord->tracking_number);
    }
} 