<?php

namespace App\Notifications;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Mail\Mailable;
use Illuminate\Mail\Mailable as BaseMailable;
use Illuminate\Queue\SerializesModels;

class ServiceStatusUpdated extends BaseMailable implements Mailable
{
    use Queueable, SerializesModels;

    public $serviceRecord;
    public $oldStatus;
    public $newStatus;
    public $description;
    public $changedBy;

    public function __construct(ServiceRecord $serviceRecord, string $oldStatus, string $newStatus, string $description, User $changedBy)
    {
        $this->serviceRecord = $serviceRecord;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
        $this->description = $description;
        $this->changedBy = $changedBy;
    }

    public function build()
    {
        return $this->markdown('emails.service-status-updated')
            ->subject('Servis Durumu Güncellendi - ' . $this->serviceRecord->tracking_number);
    }
} 