<?php

namespace App\Mail;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TechnicianAssigned extends Mailable
{
    use Queueable, SerializesModels;

    public $serviceRecord;
    public $technician;

    /**
     * Create a new message instance.
     */
    public function __construct(ServiceRecord $serviceRecord, User $technician)
    {
        $this->serviceRecord = $serviceRecord;
        $this->technician = $technician;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Servis Kaydınıza Teknisyen Atandı',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.technician-assigned',
            with: [
                'serviceRecord' => $this->serviceRecord,
                'technician' => $this->technician,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
} 