<?php

namespace App\Listeners;

use App\Events\ServiceRecordStatusChanged;
use App\Services\NetGSMService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class SendServiceStatusSMS implements ShouldQueue
{
    use InteractsWithQueue;

    protected $netgsmService;

    public function __construct(NetGSMService $netgsmService)
    {
        $this->netgsmService = $netgsmService;
    }

    public function handle(ServiceRecordStatusChanged $event)
    {
        $serviceRecord = $event->serviceRecord;
        $newStatus = $event->newStatus;

        if (!$serviceRecord->customer->phone) {
            return;
        }

        $replacements = [
            'tracking_number' => $serviceRecord->tracking_number,
            'technician_name' => $serviceRecord->technician->name ?? ''
        ];

        $message = $this->netgsmService->getTemplate($newStatus, $replacements);

        if ($message) {
            $this->netgsmService->sendSMS($serviceRecord->customer->phone, $message);
        }
    }
} 