<?php

namespace App\Listeners;

use App\Events\ServiceStatusChanged;
use App\Notifications\ServiceStatusUpdated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class HandleServiceStatusChange implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(ServiceStatusChanged $event)
    {
        // Servis kaydının durumunu güncelle
        $event->serviceRecord->update(['status' => $event->newStatus]);

        // Müşteriye bildirim gönder
        if ($event->notifyCustomer && $event->serviceRecord->customer) {
            $event->serviceRecord->customer->notify(
                new ServiceStatusUpdated(
                    $event->serviceRecord,
                    $event->oldStatus,
                    $event->newStatus,
                    $event->description
                )
            );
        }

        // Teknisyene bildirim gönder
        if ($event->serviceRecord->technician) {
            $event->serviceRecord->technician->notify(
                new ServiceStatusUpdated(
                    $event->serviceRecord,
                    $event->oldStatus,
                    $event->newStatus,
                    $event->description
                )
            );
        }
    }
} 