<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceRecordResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'tracking_number' => $this->tracking_number,
            'customer_id' => $this->customer_id,
            'module_type' => $this->module_type,
            'priority' => $this->priority,
            'problem_description' => $this->problem_description,
            'diagnosis' => $this->diagnosis,
            'solution' => $this->solution,
            'estimated_completion' => $this->estimated_completion,
            'actual_completion' => $this->actual_completion,
            'total_cost' => $this->total_cost,
            'is_warranty' => $this->is_warranty,
            'status' => $this->status,
            'assigned_technician_id' => $this->assigned_technician_id,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'relationships' => [
                'customer' => new CustomerResource($this->whenLoaded('customer')),
                'technician' => new UserResource($this->whenLoaded('technician')),
                'creator' => new UserResource($this->whenLoaded('creator')),
                'items' => ServiceItemResource::collection($this->whenLoaded('items')),
                'statuses' => ServiceStatusResource::collection($this->whenLoaded('statuses'))
            ]
        ];
    }
} 