<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceItemResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'service_record_id' => $this->service_record_id,
            'type' => $this->type,
            'brand' => $this->brand,
            'model' => $this->model,
            'serial_number' => $this->serial_number,
            'description' => $this->description,
            'specifications' => $this->specifications,
            'condition_on_receipt' => $this->condition_on_receipt,
            'accessories' => $this->accessories,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'relationships' => [
                'service_record' => new ServiceRecordResource($this->whenLoaded('serviceRecord'))
            ]
        ];
    }
} 