<?php

namespace App\Http\Controllers\Technician;

use App\Http\Controllers\Controller;
use App\Models\ServiceRecord;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TechnicianDashboardController extends Controller
{
    public function index()
    {
        $technician = Auth::user();

        // Atanan servis kayıtları
        $assignedRecords = ServiceRecord::where('technician_id', $technician->id)
            ->with(['customer', 'notes'])
            ->orderBy('priority', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        // İstatistikler
        $stats = [
            'total' => ServiceRecord::where('technician_id', $technician->id)->count(),
            'pending' => ServiceRecord::where('technician_id', $technician->id)
                ->where('status', 'pending')
                ->count(),
            'in_progress' => ServiceRecord::where('technician_id', $technician->id)
                ->where('status', 'in_progress')
                ->count(),
            'waiting_for_parts' => ServiceRecord::where('technician_id', $technician->id)
                ->where('status', 'waiting_for_parts')
                ->count(),
            'completed' => ServiceRecord::where('technician_id', $technician->id)
                ->where('status', 'completed')
                ->count(),
        ];

        // Son 7 günde tamamlanan servisler
        $completedLastWeek = ServiceRecord::where('technician_id', $technician->id)
            ->where('status', 'completed')
            ->where('updated_at', '>=', now()->subDays(7))
            ->count();

        // Ortalama tamamlanma süresi
        $averageCompletionTime = ServiceRecord::where('technician_id', $technician->id)
            ->where('status', 'completed')
            ->select(DB::raw('AVG(TIMESTAMPDIFF(HOUR, created_at, updated_at)) as avg_time'))
            ->first()
            ->avg_time;

        return view('technician.dashboard', compact(
            'assignedRecords',
            'stats',
            'completedLastWeek',
            'averageCompletionTime'
        ));
    }
} 