<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        try {
            $notifications = Auth::user()->notifications()->orderBy('created_at', 'desc')->paginate(10);
            return view('notifications.index', compact('notifications'));
        } catch (\Exception $e) {
            return redirect()->route('dashboard')->with('error', 'Bildirimler yüklenirken bir hata oluştu.');
        }
    }

    public function markAsRead($id)
    {
        try {
            $notification = Auth::user()->notifications()->findOrFail($id);
            $notification->markAsRead();
            return redirect()->route('notifications.index')->with('success', 'Bildirim okundu olarak işaretlendi.');
        } catch (\Exception $e) {
            return redirect()->route('notifications.index')->with('error', 'Bildirim işaretlenirken bir hata oluştu.');
        }
    }

    public function markAllAsRead()
    {
        try {
            Auth::user()->unreadNotifications->markAsRead();
            return redirect()->route('notifications.index')->with('success', 'Tüm bildirimler okundu olarak işaretlendi.');
        } catch (\Exception $e) {
            return redirect()->route('notifications.index')->with('error', 'Bildirimler işaretlenirken bir hata oluştu.');
        }
    }

    public function destroy($id)
    {
        try {
            $notification = Auth::user()->notifications()->findOrFail($id);
            $notification->delete();
            return redirect()->route('notifications.index')->with('success', 'Bildirim silindi.');
        } catch (\Exception $e) {
            return redirect()->route('notifications.index')->with('error', 'Bildirim silinirken bir hata oluştu.');
        }
    }

    public function destroyAll()
    {
        try {
            Auth::user()->notifications()->delete();
            return redirect()->route('notifications.index')->with('success', 'Tüm bildirimler silindi.');
        } catch (\Exception $e) {
            return redirect()->route('notifications.index')->with('error', 'Bildirimler silinirken bir hata oluştu.');
        }
    }
} 