<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SmsSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SmsSettingController extends Controller
{
    public function index()
    {
        $settings = SmsSetting::first();
        return view('admin.sms-settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'header' => 'required|string|max:11',
            'username' => 'required|string',
            'password' => 'required|string',
            'sender_number' => 'required|string|max:20',
            'templates' => 'required|array',
            'templates.*' => 'required|string',
            'is_active' => 'boolean'
        ]);

        try {
            DB::beginTransaction();

            $settings = SmsSetting::firstOrNew();
            $settings->fill($validated);
            $settings->save();

            DB::commit();

            return redirect()
                ->route('admin.sms-settings.index')
                ->with('success', 'SMS ayarları başarıyla güncellendi.');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()
                ->route('admin.sms-settings.index')
                ->with('error', 'SMS ayarları güncellenirken bir hata oluştu: ' . $e->getMessage());
        }
    }
} 