<?php

namespace App\Http\Controllers\Api\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceRecord;
use Illuminate\Support\Facades\Auth;

class CustomerServiceRecordController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $serviceRecords = ServiceRecord::where('customer_id', $user->id)
            ->with(['technician', 'statuses', 'items'])
            ->latest()
            ->paginate(10);

        return response()->json($serviceRecords);
    }

    public function show(ServiceRecord $serviceRecord)
    {
        $user = Auth::user();
        
        // Müşterinin kendi servis kaydına erişim kontrolü
        if ($serviceRecord->customer_id !== $user->id) {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        $serviceRecord->load(['technician', 'statuses', 'items', 'items.specifications', 'items.accessories']);

        return response()->json($serviceRecord);
    }
} 