<?php

namespace App\Http\Controllers\Api\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class CustomerDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $stats = [
            'total_services' => ServiceRecord::where('customer_id', $user->id)->count(),
            'active_services' => ServiceRecord::where('customer_id', $user->id)
                ->whereIn('status', ['pending', 'in_progress'])
                ->count(),
            'completed_services' => ServiceRecord::where('customer_id', $user->id)
                ->where('status', 'completed')
                ->count(),
        ];

        $recentServices = ServiceRecord::where('customer_id', $user->id)
            ->with(['technician', 'statuses'])
            ->latest()
            ->take(5)
            ->get();

        return response()->json([
            'stats' => $stats,
            'recent_services' => $recentServices
        ]);
    }
} 