<?php

namespace App\Events;

use App\Models\ServiceRecord;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ServiceStatusChanged
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $serviceRecord;
    public $oldStatus;
    public $newStatus;
    public $description;
    public $notifyCustomer;

    public function __construct(
        ServiceRecord $serviceRecord,
        ?string $oldStatus,
        string $newStatus,
        ?string $description = null,
        bool $notifyCustomer = false
    ) {
        $this->serviceRecord = $serviceRecord;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
        $this->description = $description;
        $this->notifyCustomer = $notifyCustomer;
    }
} 