<?php

namespace App\Events;

use App\Models\ServiceRecord;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ServiceRecordStatusChanged
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $serviceRecord;
    public $oldStatus;
    public $newStatus;

    public function __construct(ServiceRecord $serviceRecord, $oldStatus, $newStatus)
    {
        $this->serviceRecord = $serviceRecord;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
    }
} 